-------------------------------------------------------------------------------
-- By Alejo "Bluesummers" Grigera (MrBluesummers@MrBluesummers.com)
-- Created On: 03/12/2011
-- Tested using Max 2009 sp1
-- Best viewed in mono-spaced font.
-- Please do not re-distribute this script, just visit my site.  :)
-------------------------------------------------------------------------------
global bluesummers_MultiMaterial
try (
	rollout randMatIDs "Randomize Material IDs" width:216 height:152
	(
		fn getElements obj =
		(
			numFaces=obj.numFaces
			eles=#()
			done=#()
			for i = 1 to numFaces do
				if (finditem done i)==0 then
				(
					faces=(polyop.getElementsUsingFace obj #(i)) as array
					append eles faces
					join done faces
				)
			return eles
		)
		
		fn SelectBySmoothGroup obj theSG =
		(
			numFaces = obj.numFaces
			faces = for i = 1 to numFaces where (bit.get (polyOp.getFaceSmoothGroup obj i) theSG) collect i

			update obj
			return faces as bitarray
		)
		
		fn assignByPolygon obj =
		(
			numFaces = obj.numFaces
			for i = 1 to numFaces do
				polyOp.setFaceMatID obj #{i} (random 1 32)		
		)
		fn assignBySmoothingGroup obj =
		(
			for i = 1 to 32 do
				polyOp.setFaceMatID obj (SelectBySmoothGroup obj i) i
		)
		fn assignByObject obj =
		(
			polyOp.setFaceMatID obj #{1..(obj.numFaces)} (random 1 32)
		)
		fn assignBySubObject obj =
		(
			objectElements = getElements obj
			
			for element in objectElements do 
				polyop.setFaceMatID obj element (random 1 32)
		)
		
		fn assignRandom assignmentMode =
		(
			-- Initialize the Material
			bluesummers_MultiMaterial = multiMaterial numsubs:32
			for i = 1 to 32 do
				bluesummers_MultiMaterial[i].diffuse = random (color 0 0 0) (color 255 255 255)
			
			-- Assign according to assignmentMode
			for obj in $ do
				if classof obj == editable_poly do
				(
					$.material = bluesummers_MultiMaterial
					case assignmentMode of
					(
						1: assignByPolygon obj -- By Polygon
						2: assignBySmoothingGroup obj -- By Smoothing Group
						3: assignByObject obj -- By Object
						4: assignBySubObject obj -- By Sub-Object
					)
				)
		)
		
		radiobuttons assignmentMode "Assignment Mode" pos:[8,8] width:120 height:78 labels:#("By Polygon", "By Smoothing Group", "By Object", "By Sub-Object") columns:1
		
		HyperLink WebsiteLink "Written by Mr. Bluesummers, 2011" pos:[16,128] width:161 height:15 address:"http://www.MrBluesummers.com" across:2
		HyperLink HelpLink "Help" pos:[184,128] width:22 height:15 address:"http://www.mrbluesummers.com/4115/downloads/material-randomizer-script-download"
		button assignButton "Assign" pos:[16,96] width:184 height:24
		
		on assignButton pressed do
		(
			undo on
			(
				if selection.count == 0 then messagebox "Nothing selected!"
				else assignRandom(assignmentMode.state)					
				destroyDialog randMatIDs
			)
		)
	)

	createdialog randMatIDs lockheight:true lockwidth:true escapeEnable:true
) catch (messagebox "Something bad happened.  Canceling...")
